/* Atualizado em 19/12/2003 */

import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryExecution;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.ResultBinding;

/*
 * Created on 06/11/2003
 * 
 * @author Andrew Yuan
 *
 */

public class Teste extends Frame implements ActionListener {
	List sinonimos;
	TextField palavra;
	Panel p1;
	Button botaoGeraSinonimos, botaoRemover, botaoPesquisar;
	ArrayList vetorSinonimos;
	Model m;
	String nomeArquivo, namespace, sameClassAs, bibVirtual;
	boolean inicializado;

	public Teste() {
		super("Teste Ontologia");

		inicializaGUI();

		this.inicializado = true;

		try {
			leArquivoConf("teste.conf");
			carregaOntologia(this.nomeArquivo);
		} catch (FileNotFoundException e1) {
			this.inicializado = false;
			System.err.println("Arquivo de configuracao nao encontrado.");
		} catch (IOException e2) {
			System.err.println(
				"Problema no arquivo de configurao teste.conf.");
			this.inicializado = false;
		} catch (OntologyNotFoundException e3) {
			System.err.println(
				"Arquivo " + this.nomeArquivo + "no encontrado.");
			this.inicializado = false;
		}
	}

	public void actionPerformed(ActionEvent e) {
		Query query;
		QueryExecution qe;
		QueryResults results;
		ResultBinding rbind;
		Resource resource;

		if (!this.inicializado) {
			System.err.println("A ontologia no foi carregada.");
		} else {

			if (e.getActionCommand() == "Gerar Sinonimos") {
				String s;
				String sinonimo;
				String[] separa = palavra.getText().split(" +");
				java.util.List palavras = Arrays.asList(separa);
				Iterator it = palavras.iterator();
				while (it.hasNext()) {
					sinonimos.add(s);
					s = (String) it.next();
					if (s != "") {
						//query = new Query("SELECT ?x WHERE (<file:/home/renata/ontologias/ontologies/IABibVirt.daml#ArtificialIntelligence>, <http://www.daml.org/2001/03/daml+oil#sameClassAs>, ?x)");
						query =
							new Query(
								"SELECT ?x WHERE (<"
									+ this.namespace
									+ s
									+ ">, <"
									+ this.sameClassAs
									+ ">, ?x)");

						query.setSource(m);
						qe = new QueryEngine(query);
						results = qe.exec();
						//System.out.println("entrou");
						for (Iterator iter = results; iter.hasNext();) {
							rbind = (ResultBinding) iter.next();
							// Return from get is null if not found
							Object objx = rbind.get("x");

							Object objy = rbind.get("y");
							System.out.println(
								"x = " + objx + "   y = " + objy);
							Resource res = (Resource) objx;

							System.out.println(res.getLocalName());
							sinonimo = res.getLocalName();
							// obj will be a Jena object: resource, property or RDFNode.
							//sinonimos.add(res.getLocalName());
							try {
								sinonimos.remove(sinonimo);
							} catch (IllegalArgumentException excep) {
								//Elemento no presente na lista
							}
							sinonimos.add(sinonimo);
						}
						results.close();
					}
				}
			}
			if (e.getActionCommand() == "Remover"
				&& sinonimos.getSelectedIndex() >= 0)
				sinonimos.remove(sinonimos.getSelectedItem());

			if (e.getActionCommand() == "Pesquisar") {
				//Aqui, deveremos colocar uma chamada  pesquisa da biblioteca virtual
				String busca = new String();
				busca = palavra.getText();
				System.out.println("count = " + sinonimos.getItemCount());
				for (int i = 0; i < sinonimos.getItemCount()-1; i++) {
					busca += sinonimos.getItem(i) + " OR ";
				}
				busca += sinonimos.getItem(i);
				System.out.println(busca);
				BrowserControl.displayURL(this.bibVirtual + "?busca=" + busca);
			}
		}
	}

	private void inicializaGUI() {
		this.inicializado = false;
		setSize(400, 250);
		setLayout(new GridBagLayout());
		//Inicializando aparencia
		palavra = new TextField(40);
		palavra.setEditable(true);
		palavra.setEnabled(true);
		palavra.setName("palavra");
		sinonimos = new List(5);
		sinonimos.setEnabled(true);

		botaoGeraSinonimos = new Button("Gerar Sinonimos");
		botaoRemover = new Button("Remover");
		botaoPesquisar = new Button("Pesquisar");
		Panel p1 = new Panel(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();

		c.gridx = 0;
		c.gridy = 0;

		c.fill = GridBagConstraints.HORIZONTAL;
		p1.add(palavra, c);

		c.gridx = 0;
		c.gridy = 1;
		c.fill = GridBagConstraints.HORIZONTAL;
		p1.add(sinonimos, c);

		c.gridx = 0;
		c.gridy = 2;
		p1.add(botaoGeraSinonimos, c);

		c.gridx = 0;
		c.gridy = 3;
		p1.add(botaoRemover, c);

		c.gridx = 0;
		c.gridy = 4;
		p1.add(botaoPesquisar, c);

		add(p1);
		botaoGeraSinonimos.addActionListener(this);
		botaoRemover.addActionListener(this);
		botaoPesquisar.addActionListener(this);
		this.setLayout(new FlowLayout());
	}

	private void leArquivoConf(String arquivo)
		throws IOException, FileNotFoundException {
		FileReader entrada;
		try {
			entrada = new FileReader(arquivo);
			BufferedReader conf = new BufferedReader(entrada);
			try {
				String linha = conf.readLine();
				this.nomeArquivo = linha.substring(15, linha.length());
				linha = conf.readLine();
				this.namespace = linha.substring(10, linha.length());
				linha = conf.readLine();
				this.sameClassAs = linha.substring(12, linha.length());
				linha = conf.readLine();
				this.bibVirtual = linha.substring(18, linha.length());
			} catch (IOException e) {
				throw new IOException();
			}
		} catch (FileNotFoundException e1) {
			throw new FileNotFoundException();
		}

	}

	private void carregaOntologia(String arquivo)
		throws OntologyNotFoundException {
		try {

			InputStream in = new FileInputStream(arquivo);

			this.m = ModelFactory.createOntologyModel();
			this.m.read(in, this.namespace);

			System.out.println("Arquivo " + nomeArquivo + " lido");

		} catch (IOException excep) {
			throw new OntologyNotFoundException();
		}
	}

	public static void main(String[] args) {
		Teste teste = new Teste();
		teste.setVisible(true);

		try {
			teste.finalize();
		} catch (Throwable e) {
			e.printStackTrace();
		}

	}
}